//
//  Playing_Audio_in_the_BackgroundAppDelegate.m
//  Playing Audio in the Background
//
//  Created by Vandad Nahavandipoor on 20/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Playing_Audio_in_the_BackgroundAppDelegate.h"

@implementation Playing_Audio_in_the_BackgroundAppDelegate

@synthesize window = _window;
@synthesize audioPlayer;

- (void)audioPlayerBeginInterruption:(AVAudioPlayer *)player{
  
  /* Sesja audio zostałą przerwana. W tym miejscu nastąpi zatrzymanie odtwarzacza. */
  
}

- (void)audioPlayerEndInterruption:(AVAudioPlayer *)player
                         withFlags:(NSUInteger)flags{
  
  /* Sprawdzenie opcji. Jeśli można wznowić odtwarzanie treści audio, należy to zrobić w tym miejscu. */
  
  if (flags == AVAudioSessionInterruptionFlags_ShouldResume){
    [player play];
  }
  
}

- (void)audioPlayerDidFinishPlaying:(AVAudioPlayer *)player
                       successfully:(BOOL)flag{
  
  NSLog(@"Zakończono odtwarzanie utworu");
  
  /* Parametr informuje, czy udało się wznowić odtwarzanie treści. */
  
  if ([player isEqual:self.audioPlayer]){
    self.audioPlayer = nil;
  } else {
    /* To nie jest nasz odtwarzacz audio! */
  }
  
}

- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  dispatch_queue_t dispatchQueue = 
    dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
  
  dispatch_async(dispatchQueue, ^(void) {
    NSError *audioSessionError = nil;
    AVAudioSession *audioSession = [AVAudioSession sharedInstance];
    if ([audioSession setCategory:AVAudioSessionCategoryPlayback
                            error:&audioSessionError]){
      NSLog(@"Udało się ustawić sesję audio.");
    } else {
      NSLog(@"Nie udało się ustawić sesji audio");
    }
    
    NSBundle *mainBundle = [NSBundle mainBundle];
    
    NSString *filePath = [mainBundle pathForResource:@"MySong"
                                              ofType:@"mp3"];
    
    NSData   *fileData = [NSData dataWithContentsOfFile:filePath];
    
    NSError  *error = nil;
    
    /* Utworzenie odtwarzacza treści audio. */  
    self.audioPlayer = [[AVAudioPlayer alloc] initWithData:fileData
                                                     error:&error];
    
    /* Czy jest dostępny egzemplarz AVAudioPlayer? */
    if (self.audioPlayer != nil){
      /* Zdefiniowanie delegata i rozpoczęcie odtwarzania treści audio. */
      
      self.audioPlayer.delegate = self;
      
      if ([self.audioPlayer prepareToPlay] &&
          [self.audioPlayer play]){
        NSLog(@"Udało się rozpocząć odtwarzanie....");
      } else {
        NSLog(@"Nie udało się rozpocząć odtwarzania..");
      }
      
    } else {
      /* Nie udało się utworzyć egzemplarza AVAudioPlayer. */
    }
  });
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
